/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.utils;

import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.core.Direction;

public class RenderUtils {
    public static void rotateAroundCenterVertical(SuperByteBuffer buffer, int degreesRotated) {
        buffer.translate(0.5f, 0.5f, 0.5f);
        buffer.rotateY((float)Math.toRadians(degreesRotated));
        buffer.translate(-0.5f, -0.5f, -0.5f);
    }

    public static void rotateAroundCenterHorizontalZ(SuperByteBuffer buffer, int degreesRotated) {
        buffer.translate(0.5f, 0.5f, 0.5f);
        buffer.rotateZ((float)Math.toRadians(degreesRotated));
        buffer.translate(-0.5f, -0.5f, -0.5f);
    }

    public static void rotateToFace(SuperByteBuffer model, Direction tubeFacing, Direction attachmentDirection, boolean isTubeVertical) {
        switch (attachmentDirection) {
            case NORTH: {
                RenderUtils.rotateAroundCenterVertical(model, -90);
                break;
            }
            case EAST: {
                RenderUtils.rotateAroundCenterVertical(model, 180);
                break;
            }
            case SOUTH: {
                RenderUtils.rotateAroundCenterVertical(model, 90);
                break;
            }
            case WEST: {
                RenderUtils.rotateAroundCenterVertical(model, 0);
                break;
            }
            case UP: {
                RenderUtils.rotateAroundCenterHorizontalZ(model, -90);
                break;
            }
            case DOWN: {
                RenderUtils.rotateAroundCenterHorizontalZ(model, 90);
            }
        }
        if (!isTubeVertical) {
            if ((attachmentDirection == Direction.UP || attachmentDirection == Direction.DOWN) && tubeFacing != Direction.NORTH && tubeFacing != Direction.SOUTH) {
                return;
            }
            model.rotateXCenteredDegrees(90.0f);
        }
    }
}

