/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.server;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.net.NetManager;
import de.maxhenkel.voicechat.net.PlayerStatePacket;
import de.maxhenkel.voicechat.net.PlayerStatesPacket;
import de.maxhenkel.voicechat.net.RemovePlayerStatePacket;
import de.maxhenkel.voicechat.plugins.PluginManager;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import de.maxhenkel.voicechat.voice.server.Server;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;

public class PlayerStateManager {
    private final ConcurrentHashMap<UUID, PlayerState> states;
    private final Server voicechatServer;

    public PlayerStateManager(Server voicechatServer) {
        this.voicechatServer = voicechatServer;
        this.states = new ConcurrentHashMap();
        CommonCompatibilityManager.INSTANCE.getNetManager().updateStateChannel.setServerListener((server, player, handler, packet) -> {
            PlayerState state = this.states.get(player.m_20148_());
            if (state == null) {
                state = PlayerStateManager.defaultDisconnectedState(player);
            }
            state.setDisabled(packet.isDisabled());
            this.states.put(player.m_20148_(), state);
            this.broadcastState(player, state);
            Voicechat.LOGGER.debug("Got state of {}: {}", player.m_7755_().getString(), state);
        });
    }

    public void broadcastState(@Nullable ServerPlayer stateOwner, PlayerState state) {
        PlayerStatePacket packet = new PlayerStatePacket(state);
        for (ServerPlayer receiver : this.voicechatServer.getServer().m_6846_().m_11314_()) {
            if (stateOwner != null && !CommonCompatibilityManager.INSTANCE.canSee(receiver, stateOwner)) continue;
            NetManager.sendToClient(receiver, packet);
        }
        PluginManager.instance().onPlayerStateChanged(state);
    }

    public void broadcastRemoveState(ServerPlayer stateOwner) {
        RemovePlayerStatePacket packet = new RemovePlayerStatePacket(stateOwner.m_20148_());
        for (ServerPlayer receiver : this.voicechatServer.getServer().m_6846_().m_11314_()) {
            NetManager.sendToClient(receiver, packet);
        }
        PluginManager.instance().onPlayerStateChanged(PlayerStateManager.defaultDisconnectedState(stateOwner));
    }

    public void onPlayerCompatibilityCheckSucceeded(ServerPlayer player) {
        ArrayList<PlayerState> stateList = new ArrayList<PlayerState>(this.states.size());
        for (PlayerState state : this.states.values()) {
            ServerPlayer otherPlayer = this.voicechatServer.getServer().m_6846_().m_11259_(state.getUuid());
            if (otherPlayer == null || !CommonCompatibilityManager.INSTANCE.canSee(player, otherPlayer)) continue;
            stateList.add(state);
        }
        PlayerStatesPacket packet = new PlayerStatesPacket(stateList);
        NetManager.sendToClient(player, packet);
        Voicechat.LOGGER.debug("Sending initial states to {}", player.m_7755_().getString());
    }

    public void onPlayerLoggedIn(ServerPlayer player) {
        PlayerState state = PlayerStateManager.defaultDisconnectedState(player);
        this.states.put(player.m_20148_(), state);
        this.broadcastState(player, state);
        Voicechat.LOGGER.debug("Setting default state of {}: {}", player.m_7755_().getString(), state);
    }

    public void onPlayerLoggedOut(ServerPlayer player) {
        this.states.remove(player.m_20148_());
        this.broadcastRemoveState(player);
        Voicechat.LOGGER.debug("Removing state of {}", player.m_7755_().getString());
    }

    public void onPlayerHide(ServerPlayer visibilityChangedPlayer, ServerPlayer observingPlayer) {
        RemovePlayerStatePacket packet = new RemovePlayerStatePacket(visibilityChangedPlayer.m_20148_());
        NetManager.sendToClient(observingPlayer, packet);
        Voicechat.LOGGER.debug("Removing state of {} for {}", visibilityChangedPlayer.m_7755_().getString(), observingPlayer.m_7755_().getString());
    }

    public void onPlayerShow(ServerPlayer visibilityChangedPlayer, ServerPlayer observingPlayer) {
        PlayerState state = this.states.get(visibilityChangedPlayer.m_20148_());
        if (state == null) {
            state = PlayerStateManager.defaultDisconnectedState(visibilityChangedPlayer);
        }
        PlayerStatePacket packet = new PlayerStatePacket(state);
        NetManager.sendToClient(observingPlayer, packet);
        Voicechat.LOGGER.debug("Sending state of {} to {}", visibilityChangedPlayer.m_7755_().getString(), observingPlayer.m_7755_().getString());
    }

    public void onPlayerVoicechatDisconnect(UUID uuid) {
        PlayerState state = this.states.get(uuid);
        if (state == null) {
            return;
        }
        state.setDisconnected(true);
        ServerPlayer player = this.voicechatServer.getServer().m_6846_().m_11259_(uuid);
        this.broadcastState(player, state);
        Voicechat.LOGGER.debug("Set state of {} to disconnected: {}", uuid, state);
    }

    public void onPlayerVoicechatConnect(ServerPlayer player) {
        PlayerState state = this.states.get(player.m_20148_());
        if (state == null) {
            state = PlayerStateManager.defaultDisconnectedState(player);
        }
        state.setDisconnected(false);
        this.states.put(player.m_20148_(), state);
        this.broadcastState(player, state);
        Voicechat.LOGGER.debug("Set state of {} to connected: {}", player.m_7755_().getString(), state);
    }

    @Nullable
    public PlayerState getState(UUID playerUUID) {
        return this.states.get(playerUUID);
    }

    public static PlayerState defaultDisconnectedState(ServerPlayer player) {
        return new PlayerState(player.m_20148_(), player.m_36316_().getName(), false, true);
    }

    public void setGroup(ServerPlayer player, @Nullable UUID group) {
        PlayerState state = this.states.get(player.m_20148_());
        if (state == null) {
            state = PlayerStateManager.defaultDisconnectedState(player);
            Voicechat.LOGGER.debug("Defaulting to default state for {}: {}", player.m_7755_().getString(), state);
        }
        state.setGroup(group);
        this.states.put(player.m_20148_(), state);
        this.broadcastState(player, state);
        Voicechat.LOGGER.debug("Setting group of {}: {}", player.m_7755_().getString(), state);
    }

    public Collection<PlayerState> getStates() {
        return this.states.values();
    }
}

